<?php
namespace lib\field;

class File extends \lib\Field
{
	public $type = 'file', $file, $host;
	private $unedited, $image, $extension, $save;
	
	public function __construct($name, $validation=array(), $value='', $extension='png')
	{
		$this->save = true;
		$this->name = $name;
		$this->value = $value;
		$this->extension = $extension;
		
		$this->validation = array_merge(array
		(
			'optional'		=>	false,
			'max_filesize'	=>	ini_get('upload_max_filesize').'B'
		), $validation);
		
		$this->validation['max_filesize'] = \Pawn::inBytes($this->validation['max_filesize']);
		
		$this->host = substr($value, 0, 7) != 'http://' && substr($value, 0, 8) != 'https://';
		$this->unedited = $value;
	}
	
	public function child_of($form)
	{
		parent::child_of($form);
		
		$form->multipart();
		
		if($form->submitted)
		{
			$this->host = ($form->preset == 'administrate')?$form->request('host_'.$this->name):true;
			$this->value = get_magic_quotes_gpc()?stripslashes($form->request('url_'.$this->name)):$form->request('url_'.$this->name);
		}
	}
	
	public function validate()
	{
		$this->file = array();
		
		$this->file['url'] = substr($this->value, 0, 7) == 'http://' || substr($this->value, 0, 8) == 'https://';
		
		if($this->value != '' && $this->value == $this->unedited && $this->form->request[$this->name]['error'][$this->form->bulk] == 4)
		{
			if($this->form->preset != 'administrate' || !$this->file['url'] || !$this->host)
			{
				$this->save = false;
				
				return true;
			}
		}
		
		if($this->value != '')
		{
			if($this->file['url'])
			{
				if(!($headers = @get_headers($this->value, 1)))
				{
					return $this->set_error('invalid_url');
				}
				
				$this->file['url'] = true;
				$this->file['type'] = $headers['Content-Type'];
				$this->file['tmp_name'] = $this->value;
				
				if(isset($headers['Content-Length']))
				{
					$this->file['size'] = $headers['Content-Length'];
				} else
				{
					$this->file['contents'] = \Pawn::remote_contents($this->value);
					$this->file['size'] = strlen($this->file['contents']);
				}
				
				$this->host = $this->form->preset != 'administrate' || $this->form->request('host_'.$this->name);
			} else
			{
				$this->host = true;
				$this->file['url'] = false;
				
				if($this->form->request[$this->name]['error'][$this->form->bulk] == 4)
				{
					$this->value = '';
				} else
				{
					foreach($this->form->request[$this->name] as $key=>$array)
					{
						$this->file[$key] = $array[$this->form->bulk];
					}
				}
			}
		}
		
		return parent::validate();
	}
	
	public function input()
	{
		if($this->form->preset == 'administrate')
		{
			return '<input class="file" type="file" name="'.$this->name.'['.$this->form->bulk.']" url="'.$this->value.'" host="'.($this->host?1:0).'"/>';
		} else
		{
			return '<input class="file" type="file" name="'.$this->name.'['.$this->form->bulk.']" url="'.$this->value.'"/>';
		}
	}
	
	public function image()
	{
		if(!$this->image)
		{
			$this->image = new \lib\Image($this->file['tmp_name'], $this->file['type']);
		}
		
		return $this->image;
	}
	
	public function save($instance)
	{
		if(!$this->save)
		{
			return $this->value;
		}
		
		$path = $instance->filePath($this->name);
		$file_name = $instance->id.'.'.$this->extension;
		
		if($this->host && $this->value != '')
		{
			if($this->validation['file_type'] == 'image')
			{
				$image = $this->image();
				
				$image->validate($this->validation);
				
				$image->save($path.$file_name);
			} else
			{
				if($this->file['url'])
				{
					file_put_contents($path.$file_name, isset($this->file['contents'])?$this->file['contents']:\Pawn::remote_contents($this->file['tmp_name']));
				} else
				{
					move_uploaded_file($this->file['tmp_name'], $path.$file_name);
				}
			}
			
			$this->value = $file_name;
		} else
		{
			if(file_exists($path.$file_name))
			{
				unlink($path.$file_name);
			}
		}
		
		return $this->value;
	}
}